//
//  OPPlayerStatus.m
//  The Obfuscated Path
//
//  Created by ss2cire on 12/21/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import "OPPlayerStatus.h"
#import "OPStatusHeart.h"

@implementation OPPlayerStatus
- (id)init
{
	self = [super init];
	if(self != nil) {
		heartCount = 3;
		maxHealth = heartCount * 2;
		currentHealth = maxHealth;
		defense = 0;
		attack = 0;
		health = [[NSMutableArray alloc] initWithCapacity:3];

		int i;
		OPStatusHeart *heart = nil;
		int x = 0, yloc = 0;
		for(i = 0; i < heartCount; i++, x++) {
			heart = [[[OPStatusHeart alloc] init] autorelease];
			[heart setLocationX:x * 20];	[heart setLocationY:yloc];
			[health addObject:heart];
		}
	}
	return self;
}

- (unsigned int)attack
{
	return attack;
}

- (unsigned int)defense
{
	return defense;
}

- (unsigned int)currentHealth
{
	return currentHealth;
}

- (unsigned int)maxHealth
{
	return maxHealth;
}

- (void)incrementMaxHealth
{
	heartCount++;
	maxHealth += 2;
	currentHealth = maxHealth;
}

- (void)draw
{
	/*OPPoint location = OPMakePoint(32 * 10, 32 * 11.25);
	glPushMatrix(); {
		glTranslated(location.x, location.y, 0);

		NSEnumerator	*enumerator = [health objectEnumerator];
		OPStatusHeart *aHeart = nil;
		while((aHeart = [enumerator nextObject]) != nil) {
			[aHeart draw];
		}
	}
	glPopMatrix();*/
}

- (void)hurt
{
	currentHealth--;
	NSEnumerator	*enumerator = [health reverseObjectEnumerator];
	OPStatusHeart *aHeart = nil;
	while((aHeart = [enumerator nextObject]) != nil) {
		if([aHeart healthCount] != 0) {
			[aHeart decrementHealthCount];
			break;
		}
	}
	
}

- (void)heal
{
	currentHealth++;
	NSEnumerator	*enumerator = [health objectEnumerator];
	OPStatusHeart *aHeart = nil;
	while((aHeart = [enumerator nextObject]) != nil) {
		if([aHeart healthCount] != 2) {
			[aHeart incrementHealthCount];
			break;
		}
	}
}
@end
